/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> fluids;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    private static String trimTextureName(String name) {
        if (name.charAt(0) == '#') {
            return name.substring(1);
        }
        return name;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, modelLocation);
        Set fluidTextures = RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.fluids);
        List elements = this.model.getElements();
        int size = elements.size();
        BitSet fluidParts = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            BlockElement part = (BlockElement)elements.get(i);
            long fluidFaces = part.f_111310_.values().stream().filter(face -> fluidTextures.contains(FluidTextureModel.trimTextureName(face.f_111356_))).count();
            if (fluidFaces <= 0L) continue;
            if (fluidFaces < (long)part.f_111310_.size()) {
                TConstruct.LOG.warn("Mixed fluid and non-fluid elements in model {}, may cause unexpected results", (Object)modelLocation);
            }
            fluidParts.set(i);
        }
        return new Baked(baked, elements, owner, transform, fluidTextures, fluidParts);
    }

    public FluidTextureModel(SimpleBlockModel model, Set<String> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    private static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final Map<FluidStack, BakedModel> cache = new ConcurrentHashMap<FluidStack, BakedModel>();
        private final List<BlockElement> elements;
        private final IModelConfiguration owner;
        private final ModelState transform;
        private final Set<String> fluids;
        private final BitSet fluidParts;

        protected Baked(BakedModel originalModel, List<BlockElement> elements, IModelConfiguration owner, ModelState transform, Set<String> fluids, BitSet fluidParts) {
            super(originalModel);
            this.elements = elements;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
            this.fluidParts = fluidParts;
        }

        private BakedModel getRetexturedModel(FluidStack fluid) {
            Function spriteGetter = ForgeModelBakery.defaultTextureGetter();
            TextureAtlasSprite particle = (TextureAtlasSprite)spriteGetter.apply(this.owner.resolveTexture("particle"));
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.owner, ItemOverrides.f_111734_).m_119528_(particle);
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            int color = attributes.getColor(fluid);
            int luminosity = attributes.getLuminosity(fluid);
            RetexturedModel.RetexturedConfiguration textured = new RetexturedModel.RetexturedConfiguration(this.owner, this.fluids, attributes.getStillTexture(fluid));
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                BlockElement element = this.elements.get(i);
                if (this.fluidParts.get(i)) {
                    ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)textured, (BlockElement)element, (int)color, (int)luminosity, (ModelState)this.transform, (Function)spriteGetter, (ResourceLocation)TankModel.BAKE_LOCATION);
                    continue;
                }
                SimpleBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)this.owner, (BlockElement)element, (ModelState)this.transform, (Function)spriteGetter, (ResourceLocation)TankModel.BAKE_LOCATION);
            }
            return builder.m_119533_();
        }

        private BakedModel getCachedModel(FluidStack fluid) {
            return this.cache.computeIfAbsent(fluid, this::getRetexturedModel);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            FluidStack fluid = (FluidStack)data.getData(IDisplayFluidListener.PROPERTY);
            if (fluid != null && !fluid.isEmpty()) {
                return this.getCachedModel(fluid).getQuads(state, direction, random, data);
            }
            return this.originalModel.getQuads(state, direction, random, data);
        }
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public FluidTextureModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            ImmutableSet fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", GsonHelper::m_13805_));
            return new FluidTextureModel(model, (Set<String>)fluids);
        }
    }
}

